// Your code goes here.
(function(){
  return {
    appID: 'createTicketApp',
    defaultState: 'layout',
    targetSpoke: this.$('#zendeskSelect').val() || '',
    events: {
      'click .submitSpoke': 'createTicketValues',
      'createTicket.done': 'processData',
      'click .displayForm': 'switchToReqester'
    }, //end events
    requests: {
      createTicket: function(data) {
        return {
          url: data,
          dataType: 'JSON'
        };
      }
    }, //end requests
    processData: function(data, response, responseText) {
      console.log(responseText);
      this.switchTo('description', {
        newTicket: data.message,
        spoke: this.targetSpoke
      });
    },
    createTicketValues: function() {
      this.targetSpoke = this.$('#zendeskSelect').val();
      var spoke = 'http://'+ this.$('#zendeskSelect').val()+'/requests/embedded/create.json?';
        spoke += 'subject='+ encodeURI(this.$('#userSub').val())+'&';
        spoke += 'description='+encodeURI(this.$('#ticketDesc').val())+'&';
        spoke += 'name='+encodeURI(this.$('#userName').val())+'&';
        spoke += 'email='+ encodeURI(this.$('#userEmail').val())+'&';
        spoke += 'ticket_type_id=1&';
        spoke += 'priority_id='+this.$('#zendeskPri').val()+'&';
        spoke += 'set_tags='+this.$('#zendeskTags').val() + '+' + this.$('#zendeskType').val();
      this.ajax('createTicket', spoke);
    },
    switchToReqester: function(data) {
      this.switchTo('requester', {});
    }
  };//end first return
}());
